//>>> __using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using Framefield.Core.Rendering;
using Buffer = SharpDX.Direct3D11.Buffer;

namespace Framefield.Core.IDc567598d_a674_4429_adf3_84cef69b09b5
{
    public class Class_Shader__PBR_ : FXSourceCodeFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Scene = 1
        }
        //<<< _inputids

        #region Renderer
        public class Renderer : BaseRenderer
        {
            public override void Dispose()
            {
                Utilities.DisposeObj(ref _prefilteredSpecularCubeMapSRV);            
                Utilities.DisposeObj(ref _brdfSplitSumLookupTextureSRV);            
                Utilities.DisposeObj(ref _albedoSRV);
                Utilities.DisposeObj(ref _roughnessSRV);
                Utilities.DisposeObj(ref _metallicSRV);
                Utilities.DisposeObj(ref _normalMapSRV);
                Utilities.DisposeObj(ref _aoSRV);
                Utilities.DisposeObj(ref _emissiveSRV);
                Utilities.DisposeObj(ref _pointLightsBuffer);
                Utilities.DisposeObj(ref _pointLightsSRV);
                base.Dispose();
            }
        
            public override void SetupEffect(OperatorPartContext context)
            {
                base.SetupEffect(context);
                try
                {
                    Matrix worldToObject = Matrix.Invert(context.ObjectTWorld);
                    context.Effect.GetVariableByName("worldToObject").AsMatrix().SetMatrix(worldToObject);

                    SetupPbrPointLightsStructuredBufferForEffect(context, "PointLights", ref _pointLightsBuffer, ref _pointLightsSRV);

                    // setup IBL
                    IPbrImageBasedLightingSetup iblSetup = context.Objects[OperatorPartContext.PBR_IMAGE_BASED_LIGHTING_ID] as IPbrImageBasedLightingSetup;
                    if (iblSetup == null)
                    {
                        Logger.Warn(ParentFunc, "No IBL setup found.");
                        return;
                    }
                    
                    SetupShaderTextureParameter(context, "CubeMap", ref _prefilteredSpecularCubeMap, ref _prefilteredSpecularCubeMapSRV, iblSetup.PrefilteredSpecularCubeMap);
                    SetupShaderTextureParameter(context, "brdfSplitSumTexture", ref _brdfSplitSumLookupTexture, ref _brdfSplitSumLookupTextureSRV, iblSetup.BrdfLookupTexture);

                    context.Effect.GetVariableByName("matDiffuseR").AsMatrix().SetMatrix(iblSetup.DiffuseR);
                    context.Effect.GetVariableByName("matDiffuseG").AsMatrix().SetMatrix(iblSetup.DiffuseG);
                    context.Effect.GetVariableByName("matDiffuseB").AsMatrix().SetMatrix(iblSetup.DiffuseB);
                
                    // setup material 
                    IPbrMaterial material = context.Objects[OperatorPartContext.PBR_MATERIAL_ID] as IPbrMaterial;

                    if (material == null)
                    {
                        Logger.Warn(ParentFunc, "No PBR material set.");
                        return;
                    }

                    SetupShaderTextureParameter(context, "Albedo2", ref _albedoTexture, ref _albedoSRV, material.Albedo);
                    SetupShaderTextureParameter(context, "Roughness2", ref _roughnessTexture, ref _roughnessSRV, material.Roughness);
                    SetupShaderTextureParameter(context, "Metal", ref _metallicTexture, ref _metallicSRV, material.Metal);
                    SetupShaderTextureParameter(context, "NormalMap", ref _normalMap, ref _normalMapSRV, material.NormalMap);
                    SetupShaderTextureParameter(context, "AO", ref _aoTexture, ref _aoSRV, material.AO);
                    SetupShaderTextureParameter(context, "Emissive", ref _emissiveTexture, ref _emissiveSRV, material.Emissive);
                }
                catch (Exception e)
                {
                    Logger.Error(ParentFunc, "Error building constant buffer: {0} - Source: {1}", e.Message, e.Source);
                }
            }
            
            private void SetupShaderTextureParameter(OperatorPartContext context, string parameterName, ref Texture2D texture, ref ShaderResourceView srv, Texture2D newTexture)
            {
                if (newTexture != texture)
                {
                    texture = newTexture;
                    Utilities.DisposeObj(ref srv);
                    srv = new ShaderResourceView(context.D3DDevice, texture);
                }

                var shaderVariable = context.Effect.GetVariableByName(parameterName).AsShaderResource();
                if (shaderVariable != null)
                {
                    shaderVariable.SetResource(srv);
                }
            }
            
            public OperatorPart.Function ParentFunc {get;set;}
            
            Texture2D _prefilteredSpecularCubeMap;
            ShaderResourceView _prefilteredSpecularCubeMapSRV;            
            Texture2D _brdfSplitSumLookupTexture;
            ShaderResourceView _brdfSplitSumLookupTextureSRV;            
            Texture2D _albedoTexture;
            ShaderResourceView _albedoSRV;
            Texture2D _roughnessTexture;
            ShaderResourceView _roughnessSRV;
            Texture2D _metallicTexture;
            ShaderResourceView _metallicSRV;
            Texture2D _normalMap;
            ShaderResourceView _normalMapSRV;
            Texture2D _aoTexture;
            ShaderResourceView _aoSRV;
            Texture2D _emissiveTexture;
            ShaderResourceView _emissiveSRV;
            Buffer _pointLightsBuffer;
            ShaderResourceView _pointLightsSRV;            
        }
        #endregion

        public Class_Shader__PBR_()
        {
        }

        public override void Dispose()
        {
            Utilities.DisposeObj(ref _renderer);
            base.Dispose();
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Scene = inputs[(int)InputId.Scene];
            //<<< _params
          
            if (_renderer == null)
            {
                _renderer = new Renderer() { ParentFunc = this };
                
                for (int i = 0; i < NumCodes(); ++i)
                {
                    Compile(i);
                }
                Changed = true;
            }

            var prevEffect = context.Effect;
            var prevRenderer = context.Renderer;

            context.Effect = _effect;
            context.Renderer = _renderer;

            Scene.Eval(context);

            context.Effect = prevEffect;
            context.Renderer = prevRenderer;            

            return context;
        }

        Renderer _renderer;
    }
}


